@echo off

set program_files_path=%ProgramW6432%

if not exist "%program_files_path%" (
    set program_files_path=%ProgramFiles%
)

if not exist "%program_files_path%" (
    echo Error, program files path directory.
    pause
    exit
)

set install_dir=%program_files_path%\grandmall\
set install_data=%program_files_path%\grandmall\data\
set file_source=%~dp0grandmall_printer.exe
set file_target=%install_dir%\grandmall_printer.exe
set service_name=GrandMall_Invoice
set have_service=1

sc query %service_name% > nul
if errorlevel 1060 (
    set /a have_service=0
)

if not exist "%install_dir%" (
    echo Create directory: %install_dir%
    mkdir "%install_dir%"
)

if not exist "%install_data%" (
    echo Create directory: %install_data%
    mkdir "%install_data%"
)

if exist "%file_target%" (
    "%file_target%" stop
)

if exist "%file_source%" (
    copy "%file_source%" "%file_target%"
) else (
    echo Source file not found: grandmall_printer.exe
)

if exist "%file_target%" (
    if %have_service% == 0 (
        "%file_target%" install
        sc failure %service_name% reset= 60 actions= restart/60000/restart/60000/restart/60000
    )
    "%file_target%" start
    echo:
    echo Print service install success
) else (
    echo Print service file not found: grandmall_printer.exe
)

echo:
pause
